<?php
/**
 * Template part for displaying default header layout
 */
$sticky_on = bixol_get_opt( 'sticky_on', false );
$h_search_form = bixol_get_opt( 'h_search_form', false );
$cart_icon = bixol_get_opt( 'cart_icon', false );
$cart_icon_mobile = bixol_get_opt( 'cart_icon_mobile', false );
$top_bar = bixol_get_opt( 'top_bar', 'hide' );
$h_introductory = bixol_get_opt( 'h_introductory' );
$logo_mobile = bixol_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
?>
<header id="ct-masthead">
    <div id="ct-header-wrap" class="ct-header-layout7 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } ?>">

        <?php if($top_bar == 'show') : ?>
            <div id="ct-topbar" class="ct-topbar-layout3">
                <div class="container">
                    <div class="row">
                        <?php if(!empty($h_introductory)) : ?>
                            <div class="ct-topbar-intro">
                                <?php echo ct_print_html($h_introductory); ?>
                            </div>
                        <?php endif; ?>
                        <div class="ct-topbar-social">
                            <?php bixol_social_header(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
        <div id="ct-header" class="ct-header-main">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <div class="ct-header-branding-inner">
                            <?php get_template_part( 'template-parts/header-branding' ); ?>
                        </div>
                    </div>
                    <div class="ct-header-navigation">
                        <nav class="ct-main-navigation">
                            <div class="ct-main-navigation-inner">
                                <?php if ($logo_mobile['url']) { ?>
                                    <div class="ct-logo-mobile">
                                        <a href="<?php esc_url( esc_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr( get_bloginfo( 'name' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo_mobile['url'] ); ?>" alt="<?php esc_attr( get_bloginfo( 'name' ) ); ?>"/></a>
                                    </div>
                                <?php } ?>
                                <?php bixol_header_mobile_search(); ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                            </div>
                        </nav>
                        <?php if($h_search_form) : ?>
                            <div class="ct-header-search style2">
                                <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
                                    <input type="text" placeholder="<?php esc_attr_e('Search', 'bixol'); ?>" name="s" class="search-field" />
                                    <button type="submit" class="search-submit"><i class="fac fac-search"></i></button>
                                    <?php if(class_exists('Woocommerce') && $cart_icon) : ?>
                                        <div class="h-btn-cart">
                                            <i class="flaticonv2-shopping-cart"></i>
                                            <span class="widget_cart_counter_header"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'bixol' ), WC()->cart->cart_contents_count ); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </form>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div id="ct-menu-mobile">
                <?php if(class_exists('Woocommerce') && $cart_icon_mobile) : ?>
                    <span class="btn-nav-cart"><i class="flaticonv2-shopping-cart"></i></span>
                <?php endif; ?>
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>

    </div>
</header>